import fire
from acc_to_eps import get_epsilons


def eps_to_acc(model, data_loc, model_type, eps: float, epsilon_type='additive'):
    if eps == 'inf':
        return 0
    epsilons = get_epsilons(model, data_loc, model_type, epsilon_type)
    return (epsilons > eps).sum() / len(epsilons)


if __name__ == "__main__":
    fire.Fire(eps_to_acc)
