# Efficient Policy Space Response Oracles
The repository of an efficiency PSRO method

## Installation
```bash
# cd to the root workspace
conda create -n epsro python=3.7.9 -y
pip install -e .

# the computation of NashConv relies on deepmind's open_spiel.
# before running below installation, please make sure you've completed the dependencies for open_spiel
# please follow: https://github.com/deepmind/open_spiel
pip install -e .[open_spiel]
pip install -e .[icml]
```

## Run experiments
Before running, please make sure you've activated the conda environment like: `conda activate epsro`

**Non-transitive Mixture Games**

`python experiments/non_mixture_model.py`

**High-dimensional Matrix Games**

`python experiemnts/spinning_tops.py`

**Poker games**

For exmaple, you can run PSRO to solve kuhn poker as:
`python -m expground.cli --config experiments/configs/psro/kluh_poker_dqn.yaml`. 
More yamls for other experiments under `experiments/configs`.

**Gathering Games**

For exmaple, you can run PSRO to solve the Gathering Open as:
`python -m expground.cli --config experiments/configs/psro/gathering_open_dqn.yaml`.
More yamls for other experiments under `experiments/configs`.