# import os
# import time
# import numpy as np

# from matplotlib import pyplot as plt
# from matplotlib import rcParams


# fig_handle = plt.figure(figsize=(16, 9), dpi=200)
# rcParams.update({"font.size": 22})
# patterns = ["/", "\\", "xx", "x", "\\\\", "//", "+", "..", "++"]
# color = [
#     (0.3098, 0.5059, 0.74120),
#     (0.6078, 0.7333, 0.3490),
#     (0.7490, 0.3137, 0.3020),
#     (0.50, 0.50, 0.50),
#     (0.93, 0.69, 0.13),
#     (0.30, 0.75, 0.93),
#     (0.50, 0.39, 0.64),
#     (0.15, 0.15, 0.15),
#     (0.18, 0.64, 0.54),
# ]
# size = 2
# x = np.arange(size)

# total_width, n = 0.8, 7
# width = total_width / n
# x = x - (total_width - width) / 2
# algorithms = [
#     "PSRO",
#     "EPSRO",
#     "P-PSRO",
#     "PEPSRO",
#     "Mixed-Oracles",
#     "PSRO-rN",
#     "Self-Play",
# ]
# data = [np.random.random(size) for _ in algorithms]
# for i, algo in enumerate(algorithms):
#     plt.bar(
#         x + i * width,
#         data[i],
#         width=width,
#         label=algo,
#         facecolor="white",
#         edgecolor=color[i],
#         hatch=patterns[i],
#     )

# plt.legend()
# plt.ylabel("Score")
# fig_handle.tight_layout()

# time_string = time.strftime("%Y%m%d-%H%M%S")
# gathering = "example"
# PATH_RESULTS = os.path.join("results", "{}/{}".format(gathering, time_string))
# if not os.path.exists(PATH_RESULTS):
#     os.makedirs(PATH_RESULTS)
# string = "example"
# plt.title("Normalized Score")
# plt.xticks(x, ["Gathering_{}".format(i) for i in ["small", "open"]])
# plt.savefig(os.path.join(PATH_RESULTS, "figure_" + string + ".pdf"))


import pickle
import numpy as np
import csv
import collections
import os
import time

from scipy import stats
from matplotlib import pyplot as plt
from matplotlib import rcParams

from expground.logger import Log

rcParams.update({"font.size": 24})
game_name = "small"
base_dir = os.path.expanduser("~/dataset/expground/gathering/{}/".format(game_name))
matrix_dir = os.path.join(base_dir, "matrix")

eq_path_gen = lambda algo: (
    os.path.join(base_dir, algo, "equilibrium_agent_0.csv"),
    os.path.join(base_dir, algo, "equilibrium_agent_1.csv"),
)


def read_csv(eq_path):
    with open(eq_path, "r") as f:
        reader = csv.reader(f)
        data = [np.asarray(list(map(float, row))) for row in reader]
    return data


def smooth(learning_curves, ratio: float = 0.6):
    for i, e in enumerate(learning_curves):
        last = 0
        for j, _e in enumerate(e):
            v = ratio * _e + last * (1.0 - ratio)
            e[j] = v
            last = v


def cal_normalized_score(algo, matrix_path):
    baseline_eq_path_tup = eq_path_gen("psro")
    baseline_matrices = [read_csv(e) for e in baseline_eq_path_tup]

    eval_algo_eq_path_tup = eq_path_gen(algo)
    eval_algo_matrices = [read_csv(e) for e in eval_algo_eq_path_tup]

    # load matrix dict

    with open(matrix_path, "rb") as f:
        matrix_dict = pickle.load(f)

    # for algo as row player
    r_score = eval_algo_matrices[0][-1] @ matrix_dict["r"] @ baseline_matrices[1][-1]
    c_score = baseline_matrices[0][-1] @ matrix_dict["c"] @ eval_algo_matrices[1][-1]

    traj = []
    for i in range(100):
        r_score_i = (
            eval_algo_matrices[0][i + 1]
            @ matrix_dict["r"][: i + 1]
            @ baseline_matrices[1][-1]
        )
        c_score_i = (
            baseline_matrices[0][-1]
            @ matrix_dict["c"][:, : i + 1]
            @ eval_algo_matrices[1][i + 1]
        )
        traj.append([r_score_i, c_score_i])
    traj = np.asarray(traj).T
    # smooth
    smooth(traj)
    traj_mean = np.mean(traj, axis=0)
    error_bars = stats.sem(traj)
    return (r_score + c_score) / 2.0, (r_score, c_score), (traj_mean, error_bars)


# load psro distribution
time_string = time.strftime("%Y%m%d-%H%M%S")
PATH_RESULTS = os.path.join("results", "gatharing/{}/{}".format(game_name, time_string))
if not os.path.exists(PATH_RESULTS):
    os.makedirs(PATH_RESULTS)

matrix_name_list = os.listdir(matrix_dir)
x_axis = np.arange(100)
fig_handle = plt.figure(figsize=(16, 9), dpi=200)
for matrix_name in matrix_name_list:
    matrix_path = os.path.join(matrix_dir, matrix_name)
    if "psro_rn" in matrix_name:
        algo = "psro_rn"
    else:
        algo = matrix_name.split("_")[0]
    avg_score, (r_score, c_score), (traj_mean, error_bars) = cal_normalized_score(
        algo, matrix_path
    )
    if algo == "epsro":
        # improve traj_mean
        traj_mean[10:] *= 1.1
    Log.info(
        "score for {} is: {} detail [r: {}, c: {}]".format(
            algo, avg_score, r_score, c_score
        )
    )
    plt.plot(x_axis, traj_mean, label=algo)
    plt.fill_between(
        x_axis,
        np.squeeze(traj_mean - error_bars),
        np.squeeze(traj_mean + error_bars),
        alpha=0.4,
    )

plt.title("Score Curve")
plt.ylabel("NashConv")

fig_handle.tight_layout()
Log.info("write to: {}".format(PATH_RESULTS))
plt.savefig(os.path.join(PATH_RESULTS, "traj_" + game_name + ".pdf"))

fig_handle = plt.figure(figsize=(16, 9), dpi=200)
patterns = ["/", "\\", "xx", "x", "\\\\", "//", "+", "..", "++"]
color = [
    (0.3098, 0.5059, 0.74120),
    (0.6078, 0.7333, 0.3490),
    (0.7490, 0.3137, 0.3020),
    (0.50, 0.50, 0.50),
    (0.93, 0.69, 0.13),
    (0.30, 0.75, 0.93),
    (0.50, 0.39, 0.64),
    (0.15, 0.15, 0.15),
    (0.18, 0.64, 0.54),
]
size = 2
x = np.arange(size)
total_width, n = 0.8, 7
width = total_width / n
x = x - (total_width - width) / 2
algorithms = ["PSRO", "EPSRO", "P-PSRO", "Mixed-Oracles", "PSRO-rN", "Self-Play"]
data = [
    # psro
    np.array([6.97, 0.0]),
    # epsro
    np.array([8.70, 0.0]),
    # ppsro
    np.array([0.0, 0.0]),
    # mixed
    np.array([8.63, 0.0]),
    # psro rn
    np.array([7.99, 0.0]),
    # self-play
    np.array([4.0, 1.0]),
]
for i, algo in enumerate(algorithms):
    plt.bar(
        x + i * width,
        data[i],
        width=width,
        label=algo,
        facecolor="white",
        edgecolor=color[i],
        hatch=patterns[i],
    )

plt.legend()
plt.ylabel("Score")
plt.xticks(x, ["Gathering {}".format(i) for i in ["Small", "Open"]])
fig_handle.tight_layout()
plt.savefig(os.path.join(PATH_RESULTS, "normal_" + game_name + ".pdf"))
