DEFAULT_CONFIG = {
    "trainer": "ddpg.trainer.DDPGTrainer",
    "loss": "ddpg.loss.DDPGLoss",
    "training_config": {
        "actor_lr": 0.001,
        "critic_lr": 0.001,
        "update_interval": 1,
        "use_multihead": False,
        "optimizer": "Adam",
        "batch_size": 64,
        "gamma": 0.95,
        "tau": 0.01,
        "grad_norm_clipping": 0.5,
    },
    "model_config": {
        "actor": {
            "network": "mlp",
            "layers": [
                {"units": 64, "activation": "ReLU"},
                {"units": 64, "activation": "ReLU"},
            ],
            "output": {"activation": False},
        },
        "critic": {
            "network": "mlp",
            "layers": [
                {"units": 64, "activation": "ReLU"},
                {"units": 64, "activation": "ReLU"},
            ],
            "output": {"activation": False},
        },
    },
    "custom_config": {"use_cuda": False},
    "resource_config": {},
}


CENTRALIZED_CRITIC_NETWORK = {
    "network": "mlp",
    "layers": [
        {"units": 128, "activation": "ReLU"},
        {"units": 128, "activation": "ReLU"},
    ],
    "output": {"activation": False},
}
