# for cartpole-v1
DEFAULT_CONFIG = {
    "trainer": "ddpg.trainer.DDPGTrainer",
    "loss": "ddpg.loss.DDPGLoss",
    "training_config": {
        "critic_lr": 1e-3,
        "training_freq": 10,
        "update_interval": 1,
        "use_multihead": False,
        "optimizer": "Adam",
        "batch_size": 32,
        "gamma": 1.0,
        "tau": 0.02,
        "exploration_fraction": 0.1,
        "exploration_final_eps": 0.02,
        "total_timesteps": 100000,
    },
    "model_config": {
        "critic": {
            "network": "mlp",
            "layers": [
                # {"units": 24, "activation": "Tanh"},
                # {"units": 24, "activation": "Tanh"},
                # {"units": 256, "activation": "ReLU"},
                {"units": 64, "activation": "ReLU"},
                {"units": 64, "activation": "ReLU"},
            ],
            "output": {"activation": False},
        },
    },
    "custom_config": {
        "use_cuda": False,
    },
    "resource_config": {},
}


CENTRALIZED_CRITIC_NETWORK = {
    "network": "mlp",
    "layers": [
        {"units": 64, "activation": "ReLU"},
        {"units": 64, "activation": "ReLU"},
    ],
    "output": {"activation": False},
}
