# icml paper: ...
DEFAULT_CONFIG = {
    "trainer": "ppo.trainer.PPOTrainer",
    "loss": "ppo.loss.PPOLoss",
    "training_config": {
        "learning_rate": 0.00008,
        "vf_coef": 1.0,
        "ent_coef": 0.01,
        "clip_param": 0.27,
        # not implemented tricks
        "vf_clip_param": 10.0,
        "kl_target": 0.01,
        "update_interval": 4,
        "use_multihead": False,
        "optimizer": "Adam",
        "batch_size": 1280,
        "gamma": 0.95,
        "tau": 0.01,
        "grad_norm_clipping": 0.5,
        "share": True,
    },
    "model_config": {
        "actor": {
            "network": "mlp",
            "layers": [
                {"units": 64, "activation": "ReLU"},
                {"units": 64, "activation": "ReLU"},
            ],
            "output": {"activation": False},
        },
        "critic": {
            "network": "mlp",
            "layers": [
                {"units": 64, "activation": "ReLU"},
                {"units": 64, "activation": "ReLU"},
            ],
            "output": {"activation": False},
        },
    },
    "custom_config": {"use_cuda": False},
    "resource_config": {},
}
