import os
import gym

# from gym.wrappers import FlattenObservation, FilterObservation


def arg_parser():
    """
    Create an empty argparse.ArgumentParser.
    """
    import argparse

    return argparse.ArgumentParser(
        formatter_class=argparse.ArgumentDefaultsHelpFormatter
    )


# def atari_arg_parser():
#     """
#     Create an argparse.ArgumentParser for run_atari.py.
#     """
#     print('Obsolete - use common_arg_parser instead')
#     return common_arg_parser()

# def mujoco_arg_parser():
#     print('Obsolete - use common_arg_parser instead')
#     return common_arg_parser()


def common_arg_parser():
    """
    Create an argparse.ArgumentParser for run_mujoco.py.
    """
    parser = arg_parser()
    parser.add_argument(
        "--exp_name",
        help="custom experiment name, which used for log infos.",
        type=str,
    )
    parser.add_argument(
        "--debug",
        help="enable debug mode, ray will run in local mode.",
        action="store_true",
    )
    parser.add_argument(
        "--env_id", help="environment ID", type=str, default="Reacher-v2"
    )
    parser.add_argument(
        "--env_type",
        help="type of environment, used when the environment type cannot be automatically determined",
        type=str,
        choices={"mpe", "gym", "poker"},
    )
    parser.add_argument("--seed", help="RNG seed", type=int, default=None)
    parser.add_argument("--alg", help="Algorithm", type=str, default="ddpg")
    parser.add_argument("--num_timesteps", type=float, default=1e6),
    parser.add_argument(
        "--network",
        help="network type (mlp, cnn, lstm, cnn_lstm, conv_only)",
        default=None,
    )
    parser.add_argument(
        "--gamestate",
        help="game state to load (so far only used in retro games)",
        default=None,
    )
    parser.add_argument(
        "--num_env",
        help="Number of environment copies being run in parallel. When not specified, set to number of cpus for Atari, and to 1 for Mujoco",
        default=None,
        type=int,
    )
    parser.add_argument(
        "--reward_scale",
        help="Reward scale factor. Default: 1.0",
        default=1.0,
        type=float,
    )
    parser.add_argument(
        "--save_path", help="Path to save trained model to", default=None, type=str
    )
    parser.add_argument(
        "--save_video_interval",
        help="Save video every x steps (0 = disabled)",
        default=0,
        type=int,
    )
    parser.add_argument(
        "--save_video_length",
        help="Length of recorded video. Default: 200",
        default=200,
        type=int,
    )
    parser.add_argument(
        "--log_path",
        help="Directory to save learning curve data.",
        default="./logs",
        type=str,
    )
    parser.add_argument("--play", default=False, action="store_true")
    parser.add_argument(
        "--config",
        type=str,
        default=None,
        help="YAML configuration path, e.g. `examples/configs/dqn/...`",
    )
    return parser


def robotics_arg_parser():
    """
    Create an argparse.ArgumentParser for run_mujoco.py.
    """
    parser = arg_parser()
    parser.add_argument(
        "--env", help="environment ID", type=str, default="FetchReach-v0"
    )
    parser.add_argument("--seed", help="RNG seed", type=int, default=None)
    parser.add_argument("--num-timesteps", type=int, default=int(1e6))
    return parser


def parse_unknown_args(args):
    """
    Parse arguments not consumed by arg parser into a dictionary
    """
    retval = {}
    preceded_by_key = False
    for arg in args:
        if arg.startswith("--"):
            if "=" in arg:
                key = arg.split("=")[0][2:]
                value = arg.split("=")[1]
                retval[key] = value
            else:
                key = arg[2:]
                preceded_by_key = True
        elif preceded_by_key:
            retval[key] = arg
            preceded_by_key = False

    return retval
