import gym

from expground.types import Dict, AgentID, List, Any, Union, Tuple


class Environment:
    def __init__(self, **configs):
        self.is_sequential = False
        self._extra_returns = []
        self._trainable_agents = None
        self._configs = configs
        self._env = None

    @property
    def env(self):
        return self._env

    def get_trainable_agents(self):
        return self.trainable_agents

    def get_extra_returns(self):
        return self.extra_returns

    @staticmethod
    def from_sequential_game(env, **kwargs):
        raise NotImplementedError

    @property
    def possible_agents(self):
        return self._env.possible_agents

    @property
    def trainable_agents(self) -> Union[Tuple, None]:
        """Return trainble agents, if registered return a tuple, otherwise None"""
        return self._trainable_agents

    @property
    def observation_spaces(self) -> Dict[AgentID, gym.Space]:
        return self._env.observation_spaces

    @property
    def action_spaces(self) -> Dict[AgentID, gym.Space]:
        return self._env.action_spaces

    @property
    def extra_returns(self):
        return self._extra_returns

    def agent_to_group(self, agent_id) -> str:
        return agent_id

    def reset(self, *args, **kwargs):
        return self._env.reset()

    def step(self, actions: Dict[AgentID, Any]):
        raise NotImplementedError

    def render(self, *args, **kwargs):
        raise NotImplementedError

    def close(self):
        self._env.close()

    def seed(self, seed: int = None):
        pass
