import gym

from expground.types import Dict
from expground.utils.data import EpisodeKeys

from .env import GRF


def env_desc_gen(env_id: str, scenario_config: Dict):
    env = GRF(env_id=env_id, scenario_config=scenario_config)
    return {
        "creator": GRF,
        "config": {
            "env_id": env_id,
            "possible_agents": env.possible_agents,
            "action_spaces": env.action_spaces,
            "observation_spaces": env.observation_spaces,
            "scenario_config": scenario_config,
            "group": {"left": env._team_left, "right": env._team_right},
        },
    }


def basic_sampler_config(
    observation_space: gym.Space,
    action_space: gym.Space,
    preprocessor: object,
    capacity: int = 1000,
    learning_starts: int = 64,
):
    sampler_config = {
        "dtypes": {
            EpisodeKeys.REWARD.value: float,
            EpisodeKeys.NEXT_OBSERVATION.value: float,
            EpisodeKeys.DONE.value: bool,
            EpisodeKeys.OBSERVATION.value: float,
            EpisodeKeys.ACTION.value: int,
            EpisodeKeys.ACTION_DIST.value: float,
            EpisodeKeys.ACTION_LOGITS.value: float,
        },
        "data_shapes": {
            EpisodeKeys.REWARD.value: (),
            EpisodeKeys.NEXT_OBSERVATION.value: preprocessor.shape,
            EpisodeKeys.DONE.value: (),
            EpisodeKeys.OBSERVATION.value: preprocessor.shape,
            EpisodeKeys.ACTION.value: (),
            EpisodeKeys.ACTION_DIST.value: (action_space.n,),
            EpisodeKeys.ACTION_LOGITS.value: (action_space.n,),
        },
        "capacity": capacity,
        "learning_starts": learning_starts,
    }
    return sampler_config
