import gym

from gym.wrappers import Monitor

from expground import settings
from expground.envs import Environment
from expground.types import Dict, AgentID, Any
from expground.utils.data import EpisodeKeys


class Gym(Environment):
    def __init__(self, **configs):
        super(Gym, self).__init__(**configs)

        env_id = self._configs["env_id"]
        self.is_sequential = False
        self._env = gym.make(env_id)
        if configs.get("render", False):
            self._env = Monitor(self._env, settings.VIDEO_DIR, force=True)
        self._env.possible_agents = ["agent"]
        self._env.action_spaces = {"agent": self._env.action_space}
        self._env.observation_spaces = {"agent": self._env.observation_space}
        self._trainable_agents = ["agent"]

    def step(self, actions: Dict[AgentID, Any]) -> Dict[str, Any]:
        observation, reward, done, info = self._env.step(actions["agent"])
        # print("actions:", old_actions, actions)
        return {
            EpisodeKeys.OBSERVATION.value: {"agent": observation},
            EpisodeKeys.REWARD.value: {"agent": reward},
            EpisodeKeys.DONE.value: {"agent": done},
        }

    def render(self, *args, **kwargs):
        self._env.render()

    def reset(self):
        observation = self._env.reset()
        return {EpisodeKeys.OBSERVATION.value: {"agent": observation}}
