import collections
import random
import numpy as np
import pyspiel

from open_spiel.python.utils import file_utils

from .env import payoff_matrix_generate


def _create_game(given_matrix=None):
    raise NotImplementedError
    # if given_matrix is None:
    #     # random generate
    #     pass
    # else:
    #     pass

    # game_type = pyspiel.GameType(
    #     "random_symmetric_normal_form",
    #     "Randmo Symmetric Normal Form",
    #     pyspiel.GameType.Dynamics.SEQUENTIAL,
    #     pyspiel.GameType.ChanceMode.DETERMINISTIC,
    #     pyspiel.GameType.Information.ONE_SHOT,
    #     pyspiel.GameType.Utility.ZERO_SUM,
    #     pyspiel.GameType.RewardModel.TERMINAL,
    #     max_num_players,
    #     min_num_players,
    #     True,  # provides_information_state
    #     True,  # provides_information_state_tensor
    #     False,  # provides_observation
    #     False,  # provides_observation_tensor
    #     dict(),  # parameter_specification
    # )

    # game = pyspiel.MatrixGame(
    #     game_type,
    #     {},  # game_parameters
    #     ["Heads", "Tails"],  # row_action_names
    #     ["Heads", "Tails"],  # col_action_names
    #     [[-1, 1], [1, -1]],  # row player utilities
    #     [[1, -1], [-1, 1]],  # col player utilities
    # )

    # return game


def _easy_create_game(
    name1, name2, row_action, colum_action, row_payoff, column_payoff
):
    """Uses the helper function to create the same game as above."""
    return pyspiel.create_matrix_game(
        name1,  # "matching_pennies",
        name2,  # "Matching Pennies",
        row_action,  # ["Heads", "Tails"],
        colum_action,  # ["Heads", "Tails"],
        row_payoff,  # [[-1, 1], [1, -1]],
        column_payoff,  # [[1, -1], [-1, 1]],
    )


def from_payoff_tables(row_payoff, column_payoff):
    """Leave out the names too, if you prefer."""
    # return pyspiel.create_matrix_game([[-1, 1], [1, -1]], [[1, -1], [-1, 1]])
    return pyspiel.create_matrix_game(row_payoff, column_payoff)


def _import_data_create_game():
    """Creates a game via imported payoff data."""
    payoff_file = file_utils.find_file(
        "open_spiel/data/paper_data/response_graph_ucb/soccer.txt", 2
    )
    payoffs = np.loadtxt(payoff_file) * 2 - 1
    return pyspiel.create_matrix_game(payoffs, payoffs.T)


def main(_):
    games_list = pyspiel.registered_games()
    print("Registered games:")
    print(games_list)

    # Load a two-player normal-form game as a two-player matrix game.
    blotto_matrix_game = pyspiel.load_matrix_game("blotto")
    print(
        "Number of rows in 2-player Blotto with default settings is {}".format(
            blotto_matrix_game.num_rows()
        )
    )

    # Several ways to load/create the same game of matching pennies.
    print("Creating matrix game...")
    game = pyspiel.load_matrix_game("matrix_mp")
    game = _create_game()
    game = _import_data_create_game()
    game = _easy_create_game()
    game = from_payoff_tables()

    # Quick test: inspect top-left utility values:
    print(
        "Values for joint action ({},{}) is {},{}".format(
            game.row_action_name(0),
            game.col_action_name(0),
            game.player_utility(0, 0, 0),
            game.player_utility(1, 0, 0),
        )
    )

    state = game.new_initial_state()

    # Print the initial state
    print("State:")
    print(str(state))

    assert state.is_simultaneous_node()

    # Simultaneous node: sample actions for all players.
    chosen_actions = [
        random.choice(state.legal_actions(pid)) for pid in range(game.num_players())
    ]
    print(
        "Chosen actions: ",
        [
            state.action_to_string(pid, action)
            for pid, action in enumerate(chosen_actions)
        ],
    )
    state.apply_actions(chosen_actions)

    assert state.is_terminal()

    # Game is now done. Print utilities for each player
    returns = state.returns()
    for pid in range(game.num_players()):
        print("Utility for player {} is {}".format(pid, returns[pid]))
