import gym
import numpy as np

from expground.types import Dict
from expground.utils.data import EpisodeKeys

from .env import MPE
from . import adapter


def env_desc_gen(env_id: str, scenario_config: Dict):
    env = MPE(env_id=env_id, scenario_config=scenario_config)
    return {
        "creator": MPE,
        "config": {
            "env_id": env_id,
            "possible_agents": env.possible_agents,
            "action_spaces": env.action_spaces,
            "observation_spaces": env.observation_spaces,
            "scenario_config": scenario_config,
        },
    }


def basic_sampler_config(
    observation_space: gym.Space,
    action_space: gym.Space,
    preprocessor: object,
    capacity: int = 1000,
    learning_starts: int = 64,
):
    discrete_action = isinstance(action_space, gym.spaces.Discrete)
    sampler_config = {
        "dtypes": {
            EpisodeKeys.REWARD.value: np.float,
            EpisodeKeys.NEXT_OBSERVATION.value: np.float,
            EpisodeKeys.DONE.value: np.bool,
            EpisodeKeys.OBSERVATION.value: np.float,
            EpisodeKeys.ACTION.value: np.int if discrete_action else np.float,
            EpisodeKeys.ACTION_DIST.value: np.float,
        },
        "data_shapes": {
            EpisodeKeys.REWARD.value: (),
            EpisodeKeys.NEXT_OBSERVATION.value: preprocessor.shape,
            EpisodeKeys.DONE.value: (),
            EpisodeKeys.OBSERVATION.value: preprocessor.shape,
            EpisodeKeys.ACTION.value: () if discrete_action else action_space.shape,
            EpisodeKeys.ACTION_DIST.value: (action_space.n,)
            if discrete_action
            else action_space.shape,
        },
        "capacity": capacity,
        "learning_starts": learning_starts,
    }
    return sampler_config
