import importlib
import numpy as np
from pettingzoo.mpe._mpe_utils import scenario

from expground.envs import Environment
from expground.types import Dict, Any, AgentID
from expground.utils.data import EpisodeKeys

from pettingzoo.mpe import simple_adversary_v2


class MPE(Environment):
    def __init__(self, **configs):
        super(MPE, self).__init__(**configs)

        env_id = self._configs["env_id"]
        scenario_configs = self._configs.get("scenario_config", {})

        env_module = importlib.import_module(f"pettingzoo.mpe.{env_id}")
        ori_caller = env_module.parallel_env

        self.is_sequential = False
        self._env = ori_caller(**scenario_configs)
        self._trainable_agents = self._env.possible_agents

    def step(self, actions: Dict[AgentID, Any]) -> Dict[str, Any]:
        observations, rewards, dones, infos = self._env.step(actions)
        return {
            EpisodeKeys.OBSERVATION.value: observations,
            EpisodeKeys.REWARD.value: rewards,
            EpisodeKeys.DONE.value: dones,
        }

    def render(self, *args, **kwargs):
        self._env.render()

    def reset(self):
        observations = self._env.reset()
        return {EpisodeKeys.OBSERVATION.value: observations}
