import enum


class Dynamics(enum.Enum):
    SEQUENTIAL = "sequential"
    """sequential game"""

    SIMULTANEOUS = "simultaneous"
    """simultaneous game"""

    MEANFIELD = "meanfield"
    """mean field game"""


class ChanceMode(enum.Enum):
    EXPLICIT_STOCHASTIC = "explicit_stochastic"
    """has at least one chance node, all with determinstic apply action"""

    DETERMINISTIC = "deterministic"
    """no chance node"""

    SAMPLED_STOCHASTIC = "sampled_stochastic"
    """at least one chance node with non-deterministic apply action"""


class Information(enum.Enum):
    IMPERFECT_INFORMATION = "imperfect_information"
    """some information is hidden from some players"""

    PERFECT_INFORMATION = "perfect_information"
    """all players know the state of the game"""

    ONE_SHOT = "one_shot"
    """aka normal-form games (single simultaneous turn)."""


class RewardModel(enum.Enum):
    TERMINAL = "terminal"
    """return reward only at terminals"""

    INTERMEDIATE = "intermediate"
    """rl-style func r(s,a,s')"""


class Utility(enum.Enum):
    ZERO_SUM = "zero_sum"
    """utilities of all players sum to 0"""

    GENERAL_SUM = "general_sum"
    """total utility of all players differes in differnt outcomes"""

    CONSTANT_SUM = "custant_sum"
    """utitlies of all players differs in different outcomes"""

    IDENTICAL = "identical"
    """every player gets an identical value (cooperative game)"""


class PrivateInfoType(enum.Enum):
    SINGLE_PLAYER = "single_player"
    MULTI_PLAYER = "multi_player"
    NONE = "none"


class PlayerId(enum.IntEnum):
    DEFAULT = 0
    """normal player id should be no less than 0."""

    CHANCE = -1
    """chance id when the state node is a chance node."""

    SIMULTANEOUS = -2
    """what is returned as a player id when the game is simultaneous."""

    INVALID = -3
    """invalid player."""

    TERMINAL = -4
    """what is returned as the player id on terminal nodes."""

    MEANFIELD = -5
    """player id of a mean field node."""
