import pyspiel


def from_simple_description(
    name1, name2, row_action, colum_action, row_payoff, column_payoff
):
    """Uses the helper function to create the same game as above."""
    return pyspiel.create_matrix_game(
        name1,  # "matching_pennies",
        name2,  # "Matching Pennies",
        row_action,  # ["Heads", "Tails"],
        colum_action,  # ["Heads", "Tails"],
        row_payoff,  # [[-1, 1], [1, -1]],
        column_payoff,  # [[1, -1], [-1, 1]],
    )


def from_game_type(rdim, cdim, row_payoff, column_payoff):
    """Creates the game manually from the spiel building blocks."""
    game_type = pyspiel.GameType(
        "random",
        "Random",
        pyspiel.GameType.Dynamics.SIMULTANEOUS,
        pyspiel.GameType.ChanceMode.DETERMINISTIC,
        pyspiel.GameType.Information.IMPERFECT_INFORMATION,
        pyspiel.GameType.Utility.ZERO_SUM,
        pyspiel.GameType.RewardModel.TERMINAL,
        2,  # max num players
        2,  # min_num_players
        True,  # provides_information_state
        True,  # provides_information_state_tensor
        False,  # provides_observation
        False,  # provides_observation_tensor
        {}
        #   dict(players=2)  # parameter_specification
    )
    game = pyspiel.MatrixGame(
        game_type,
        {},
        list(map(str, range(rdim))),  # row_action_names
        list(map(str, range(cdim))),  # col_action_names
        row_payoff,  # row player utilities
        column_payoff,  # col player utilities
    )
    return game


def from_payoff_tables(row_payoff, column_payoff):
    """Leave out the names too, if you prefer."""
    # return pyspiel.create_matrix_game([[-1, 1], [1, -1]], [[1, -1], [-1, 1]])
    return pyspiel.create_matrix_game(row_payoff, column_payoff)
