"""
Experiment manager: schedule the experiment
- Logger server (ws://ip:port)
- Experiment # dispatched to different machines
    - logger client (ws://ip:port)
    - learner
        - algorithm
        - optimizer
        - evaluator

Usage:

experiment = Experiment(
    name="custom",
    learner="independent",
    algorithm="PPO",
    evaluator="generic",
    # default is None,
    grid_search={},
    config={
        "training_iteration": 1,
        "batch_size": 128,
    }
)

experiment_manager = ExperimentManager(
    resources={
        "ips": [],
    },
    strategy="balance"
)
experiment_manager.register(experiment, readable_name="custom")
experiment_manager.start()
"""

from typing import Dict


GLOBAL_CONFIG = {}


def with_update(config: Dict):
    return GLOBAL_CONFIG
