from typing import Dict
from expground import algorithms
from expground import experiment

from expground.evaluator.base_evaluator import Evaluator
from expground.learner.base_learner import Learner
from expground.algorithms import Algorithm
from expground.experiment import with_update
from expground.logger.client import Client as Logger


class Experiment:
    def __init__(
        self,
        name: str,
        learner: Learner,
        algorithm: Algorithm,
        evaluator: Evaluator,
        grid_search: Dict = None,
        config: Dict = None,
    ):
        self._name = name
        self._learner = learner
        self._algorithm = algorithm
        self._evaluator = evaluator

        self._grid_search = grid_search
        self._config = with_update(config)

        self._logger = Logger(self._config["logger"], experiment_name=name)

    @property
    def state(self):
        raise NotImplementedError

    def run(self):
        raise NotImplementedError

    def resume(self):
        raise NotImplementedError

    def stop(self):
        raise NotImplementedError
