from typing import Dict
from expground.experiment.experiment import Experiment
from expground.logger.server import LoggingServerProcess


class ExperimentManager:
    def __init__(self, resources: Dict, strategy: str) -> None:
        self._experiments = {}
        self._resources = resources
        self._strategy = strategy

        LoggingServerProcess(port=8081, max_capacity_mb=500.0).start()

        self._dispatch()

    def register(self, instance: Experiment, readable_name: str = None):
        self._experiments[readable_name or instance.name] = instance

    def start(self):
        raise NotImplementedError

    def _dispatch(self) -> None:
        """Dispatch experiment according to the strategy and computing resources

        Raises:
            NotImplementedError: [description]
        """
        raise NotImplementedError

    def _collect_info(self):
        pass
