from expground.learner.sp import SelfPlay
from expground.learner.psro import PSROLearner, BPSROLearner, P2SROLearner
from expground.learner.centralized import CentralizedLearner
from expground.learner.independent import IndependentLearner
from expground.learner.do import DOLearner, BDOLearner


LEARNER = {
    "sp": SelfPlay,
    "psro": PSROLearner,
    "independent": IndependentLearner,
    "centralized": CentralizedLearner,
    "do": DOLearner,
    "bdo": BDOLearner,
    "bpsro": BPSROLearner,
    "p2sro": P2SROLearner,
}


def get_learner(name: str):
    if name in LEARNER.keys():
        return LEARNER[name]
    else:
        raise KeyError(f"Unexpected trainer named with: {name}")
