import logging
import time

import pytest
import numpy as np

from expground.logger import Client, LoggingServerProcess, logging_client_set, ClientSet


logger = logging.getLogger(__name__)


@pytest.fixture(scope="session")
def server():
    proc = LoggingServerProcess()
    logger.info("Logging server has been started in localhost:8081 ...")
    return proc


@pytest.fixture(scope="session")
def custom_client(server: LoggingServerProcess):
    logging_client_set.register(experiment_name="custom", endpoint=server.endpoint)
    # time.sleep(5)
    logger.info("created custom logging client named `custom`")
    return logging_client_set.get_handler("custom")


# def test_test_start_server(server: LoggingServerProcess):
#     pass


class TestMessageType:
    def test_scalar_float(self, custom_client: ClientSet.Handler):
        scalar = 1.0
        custom_client.send(scalar)

    def test_scalar_int(self, custom_client: ClientSet.Handler):
        scalar = 1
        custom_client.send(scalar)

    def test_string(self, custom_client: ClientSet.Handler):
        string = "Hello, World!"
        custom_client.send(string)

    def test_vector(self, custom_client: ClientSet.Handler):
        vector = np.random.random(10)
        custom_client.send(vector)

    def test_scalars(self, custom_client: ClientSet.Handler):
        scalars = [1, 2, 3, 4]
        custom_client.send(scalars)

    def test_vectors(self, custom_client: ClientSet.Handler):
        vectors = [np.random.random(10) for _ in range(4)]
        custom_client.send(vectors)


def test_multiple_client(server: LoggingServerProcess):
    exps = [f"test_{i}" for i in range(4)]
    handlers = {exp: None for exp in exps}
    for exp_name in exps:
        logging_client_set.register(experiment_name=exp_name, endpoint=server.endpoint)
        handlers[exp_name] = logging_client_set.get_handler(exp_name)

    for exp_name, handler in handlers.items():
        handler.send(f"Hello world from {exp_name}")

    logging_client_set.close_all()


def test_shared_client(server):
    logging_client_set.register(experiment_name="test1", endpoint=server.endpoint)
    handlers = [logging_client_set.get_handler("test1") for _ in range(4)]
    for idx, handler in enumerate(handlers):
        handler.send(f"Hello workd from {idx}")
    # .... send msg in sharing mode
    logging_client_set.close("test1")
