from abc import ABCMeta, abstractmethod


class PolicyOptimizeInterface(metaclass=ABCMeta):
    def __init__(self, policy):
        self._policy = policy
        self.batch = None
        self.other_agent_batch = None

    @property
    def policy(self):
        return self._policy

    @abstractmethod
    def ready_batched_data(self, data, other_agent_data):
        pass

    @abstractmethod
    def get_weights(self):
        pass

    @abstractmethod
    def loss(self):
        pass

    @property
    def objective(self):
        """Accept theta as input, then return an evaluation result (could be a loss)"""

        raise NotImplementedError
