import os
import logging


def reset_dir(new_base_dir=None):
    global BASE_DIR, LOG_DIR, LOG_LEVEL, SESSION_SUB_DIR_NAME, MODEL_SUB_DIR_NAME, DATA_SUB_DIR_NAME, VIDEO_DIR, EXP_NAME_FORMAT_LAMBDA, DATABASE

    if new_base_dir is None:
        BASE_DIR = os.path.dirname(os.path.dirname(os.path.abspath(__file__)))
    else:
        BASE_DIR = new_base_dir
    LOG_DIR = os.path.join(BASE_DIR, "logs")
    LOG_LEVEL = logging.INFO

    SESSION_SUB_DIR_NAME = "tensorboard"
    MODEL_SUB_DIR_NAME = "model"
    DATA_SUB_DIR_NAME = "dataset"
    VIDEO_DIR = os.path.join(LOG_DIR, "videos")
    DATABASE = os.path.join(os.path.expanduser("~"), "dataset/expground")
    EXP_NAME_FORMAT_LAMBDA = lambda args: "_".join(
        [str(e) for e in args if e is not None]
    )


# for test and debug, ray will startup in local mode if RAY_DEBUG_MODE = "local", otherwise remote mode.
RAY_DEBUG_MODE = "local"
PAYOFF_SERVER_ACTOR = "PayoffServer"

reset_dir()
