def pretty_dict(d, indent=0):
    res = ""
    for k, v in d.items():
        res += "\t" * indent + str(k)
        if isinstance(v, dict):
            res += "\n" + pretty_dict(v, indent + 1)
        else:
            res += ": " + str(v) + "\n"
    return res


def pretty_list(l, indent=0):
    res = "[" + "\n"
    for i in l:
        res += "\t" * indent + str(i) + "\n"
    res += "]"
    return res


POLICY_NAME_GEN = lambda algorithm, time_stamp: f"{algorithm}-{time_stamp}"


if __name__ == "__main__":
    a = {
        "agent-0": {"policy-1": 0.323, "policy-2": 0.4, "policy-3": 0.3},
        "agent-1": {"policy-1": 0.3, "policy-2": 0.4, "policy-3": 0.3},
        "agent-2": {"policy-1": 0.3, "policy-2": 0.4, "policy-3": 0.3},
    }
    print(pretty_dict(a))
