import dataclasses
import hashlib
import os
import shutil
from contextlib import contextmanager


# https://stackoverflow.com/a/2166841
def isnamedtupleinstance(x):
    t = type(x)
    b = t.__bases__
    if len(b) != 1 or b[0] != tuple:
        return False
    f = getattr(t, "_fields", None)
    if not isinstance(f, tuple):
        return False
    return all(type(n) == str for n in f)


def isdataclass(x):
    return dataclasses.is_dataclass(x)


def hashit(x):
    s = ""
    for k, v in x.items():
        s += str(k) + ":"
        for e in v:
            s += e
    return s


def unpack(obj):
    """A helper that can be used to print `nestedtuples`. For example,

    Examples:
        >>> pprint(unpack(obs), indent=1, width=80, compact=True)
    """
    if isinstance(obj, dict):
        return {key: unpack(value) for key, value in obj.items()}
    elif isinstance(obj, list):
        return [unpack(value) for value in obj]
    elif isnamedtupleinstance(obj):
        return {key: unpack(value) for key, value in obj._asdict().items()}
    elif isdataclass(obj):
        return dataclasses.asdict(obj)
    elif isinstance(obj, tuple):
        return tuple(unpack(value) for value in obj)
    else:
        return obj
