import importlib

from expground.types import Dict, Tuple


def load_class_from_str(prefix, module_class_string):
    module_name, class_name = module_class_string.rsplit(".", 1)
    module = importlib.import_module("%s.%s" % (prefix, module_name))
    assert hasattr(module, class_name), "class {} is not in {}".format(
        class_name, module_name
    )
    return getattr(module, class_name)


def parse_env_config(env_config: Dict) -> Tuple[Dict, type]:
    env_lib = importlib.import_module(env_config["lib"])
    scenario_config = env_config.get("params", {})
    env_desc = env_lib.env_desc_gen(env_config["env_id"], scenario_config)
    return env_desc, env_lib
