from os import path
from setuptools import find_packages, setup


DIR = path.abspath(path.dirname(__file__))
with open(path.join(DIR, "README.md"), encoding="utf-8") as f:
    long_desc = f.read()

# ========== basic requirements ============
basic_requires = [
    "ray==1.7.0",
    "pettingzoo==1.14.0",
    "nashpy==0.0.21",
    "tornado==6.1",
    "websocket==0.2.1",
    "websocket-client==1.1.0",
    "tensorboard==2.7.0",
    "gym==0.21.0",
    "colorlog==5.0.1",
    # for data serialization
    "tabulate==0.8.9",
    "opencv-python==4.5.3.56",
    "pygame==2.0.1",
    "numpy>=1.21.3",
]

# ========== requirements for development ===========
dev = ["pip==21.0.1", "black==20.8b1", "pytest==6.2.4"]

# ========== open spiel ===============
open_spiel = ["open_spiel==1.0.2", "matplotlib==3.4.3", "networkx==2.6.3"]

# ========== visualization ============
viz = ["seaborn==0.11.2"]

# =========== for benchmark ============
# marl_benchmark = []

# ========== mujoco ==============
extra_envs = ["mujoco-py==2.0.2.13", "gfootball==2.10.1"]

# ============ spinningtop ===========
spining_tops = [
    "kiwisolver==1.3.1",
]

# ============ icml ================
icml = ["ray[rllib]", "kiwisolver==1.3.1", "seaborn==0.11.2"]

setup(
    name="expground",
    description="A experiment playground for machine learning.",
    long_description_content=long_desc,
    version="0.1.0",
    packages=find_packages(exclude="tests"),
    include_packages_data=True,
    zip_safe=True,
    python_requires=">=3.7",
    install_requires=basic_requires,
    extras_require={
        "dev": dev,
        "open_spiel": open_spiel,
        "mujoco": extra_envs,
        "viz": viz,
        "icml": icml,
    },
)
