import pytest
import ray

from expground.settings import RAY_DEBUG_MODE
from expground.learner.psro import PSROLearner
from expground.gt.payoff_matrix import RectifierType


def setup_module(module):
    # we enable ray in local mode
    if not ray.is_initialized():
        ray.init(local_mode=(RAY_DEBUG_MODE == "local"))


class TestPSROLearner:
    @pytest.fixture(autouse=True)
    def init_learner(self):
        self.learner = PSROLearner(
            meta_solver=None,
            policy_config=None,
            env_description=None,
            rollout_config=None,
            training_config=None,
            loss_func=None,
            learning_mode=None,
            episodic_training=None,
            train_every=None,
            use_learnable_dist=None,
            experiment="test",
            ray_mode=None,
            seed=None,
            mixed_at_every_step=None,
            independent_learning=None,
            evaluation_worker_num=None,
            distribution_training_kwargs=None,  # kwargs for learnable meta strategy
            centralized_critic_config=None,
            rectifier_type=None,  # refer to expround.utils.payoff_matrix.RectifierType
        )

    def test_getter_and_setter(self):
        """Test easy APIs, like methods decorated by @property"""
        pass
