import torch
cos = torch.cos
sin = torch.sin


def Fourier_fitting_p_coeff(args, input_data, output_data, Series_order):
	r = args.R_bd  # radius of disk
	t = torch.transpose(input_data,0,1) # theta of disk
	y = output_data
	N = Series_order
	Size = args.S_boundary+1
	p0 = torch.ones(Size)@y/Size
	Re_p = torch.zeros(N+1)
	Im_p = torch.zeros(N+1)
	for i in range(1,N+1):
		Re_p[i] = cos(i*t)@y/Size/(r**i)
		Im_p[i] = -sin(i*t)@y/Size/(r**i)

	return p0, Re_p, Im_p