import json
import matplotlib.pyplot as plt

# Load the JSON data
with open('llama2-7b-attn-sim.json', 'r') as file:
    data = json.load(file)

# Set up the plot
fig, axes = plt.subplots(8, 4, figsize=(20, 40))
fig.tight_layout(pad=5.0)

# Iterate over the data and create a bar chart for each key
for i, (key, values) in enumerate(data.items()):
    ax = axes[i // 4, i % 4]
    ax.bar(range(len(values)), values)
    ax.set_title(f'Key: {key}')
    ax.set_xlabel('Index')
    ax.set_ylabel('Value')
    ax.set_ylim(0, 1)  # Since the values are between 0 and 1

plt.savefig('attn_sim_plot_layer.png')
