# Supplementary Materials: Code for DeMe
The codebase is based upon [diffusers](https://github.com/huggingface/diffusers), thanks to all the developers of diffusers!

## 0. Requirements, Data and Pretrained Model
In this section, we setup the conda environment, prepare the dataset and pretrained model checkpoint with Huggingface

- Conda Environment Settings

Plase create `DeMe` conda environment with the following commands:
```bash[] 
conda env create -f environment.yml
```

- Data Preparation

For convenience, we use [LSUN-Church](https://huggingface.co/datasets/tglcourse/lsun_church_train) from Huggingface without downloading data by using the `load_dataset` function offered by the `datasets` library. Additionally, you can also download the dataset yourself.


- Pretrained Model

We use an official DDPM model offered by Google in Huggingface, named [ddpm-ema-church-256](https://huggingface.co/google/ddpm-ema-church-256). You can download the pretrained DDPM model at `ddpm-ema-church-256/` for the following experiments.

## 1. *Decouple*: Finetune DDPM at 4 Different Timestep Ranges
Finetune the pretrained DDPM and save finetuned model
```bash[]
sh lsun_church_deme.sh
```

## 2. *Merge*: Merge Finetuned Diffusion Models into One Unified Model
Compute task vectors and merge finetuned diffusion models into one diffusion model
```python[]
python merge.py
```

*For the convenience of the reviewers, we have provided the merged model weights on the LSUN-Church, which can be downloaded [here](https://drive.google.com/file/d/1v0rnyNyQOgTzvD5RLsBYpDAN1y21c50l/view?usp=sharing). You can download the merged model weights to path 'merged_models/diffusion_pytorch_model.bin' and continue to evaluate the FID in the following steps.*

## 3. Compute FID Scores to Evaluate DeMe
To accelerate sampling process, we use multiple GPUs to sample
```bash[]
sh merge_run_ddp_single.sh
```

We offer a `church_fid.npz` file here to evaluate the generated images quality, use the command line to compute FID
```bash[]
python -m pytorch_fid "ddim_samples/merge/reproduce_deme" "church_fid.npz"
```
to reproduce the results demonstrated in paper.
