# Path learning

## Instructions for running

### 0. Google Sheet 
The following steps will enable the posting of experimental results to a GoogleSheet of your choice. 
This is not required, but greatly helps visualization of results otherwise saved in logs. 

Steps:
1. Go to: 
https://console.developers.google.com/apis/dashboard

2. Create a new project for which we will create a new service account. 
3. In the bar on the left - Go to credentials (symbol of a key)
4. On the top, click “create credentials” - create a service account there
5. Once created, stay in “credentials”. Click on the created service account at the bottom at create a new key. 
This will trigger a download of a json file containing the key. 

6. Place this json file into a folder of your choice onto the same computer as your path_learning codebase, to access it from the path_learning codebase. 
Write down the service account email address. It should be of the form 
“
serviceaccountname@projectname.iam.gserviceaccount.com
"
7. Add this email address to the GoogleSheet you want to use with “edit” rights. The computer will then be able to use this account to publish new experimental results in the GoogleSheet. 
8. Finally, ensure that both the Google Sheets and Google Drive API are activated for the GoogleAPI project.  IMPORTANT: Ensure that both these APIs (Google Sheets and Google Drive) are enabled. Otherwise you may encounter problems uploading experimental results. 

Once you provide the name of the GoogleSheet and the location of the key in the following installation steps, the GoogleSheet can be used. 

### 1. Installation:
This framework requires **Python >=3.7** and is currently used on Ubuntu 16.04

**Note:** Cuda 10.2 needs to be installed and available.

It is recommended to use a package manager like Conda (https://docs.conda.io/en/latest/) to manage the Python version 
and all required Python packages.

The required Python packages can be installed as follows (within the Conda environment) in the root directory:
```
python setup.py
```

This script will also ask you for a valid path to store experiments in (make sure you have sufficient storage),
a valid path to your GoogleAPI credentials and the name of the chosen GoogleSheet. 
Within the chosen experiment directory, the framework will create a data and a logs folder.

### 2. Running an experiment

We use JSON config files to specify all settings and parameters of our experiments. 
All config files need to be placed in a subdirectory of `{DIR_TO_REPO}/configs`.
More details about the available options in the config files are provided in `{DIR_TO_REPO}/CONFIGS_README.md`.
Subsequently, an experiment can be started by stating the path relative to the `{DIR_TO_REPO}/configs` directory:

```
python main.py {CONFIG_NAME}.json
```
(The python should be >=3.7 because of type setting)

Example:
To run one of the mutually frozen weights experiments to create Tab. 1 in the paper submission run:

```
python main.py MutualDoubleMonoSparse/CIFAR10_baseline_allconv_mutually_frozen_02.json

```

### Remarks

To run experiments that are not readily available via torchvision, you will need to download
and provide the required dataset in your dataset folder, specified when you install this package.
The ROOT folder of this code base is listed in "folder_path_settings.json" which is created when running
"setup.py".


## Important components

### Task Path
The main ingredient to path learning are what we call task paths. 
They consist of different "training regimes" applied sequentially to a machine learning model. 
In our implementation they create tasks from their configs and are used as iterators to yield these tasks.
### Task
A task consists of a set of dataloaders, which are created from a base dataset (i.e. MNIST) and transformers applied to it. 
Moreover it also specifies a loss function, loss aggregator and the batch size for the dataloader.
In our implementation tasks measure their own runtime by using the "with" keyword.

### Controller
The controller is a member of the learning classes. It is implemented as an iterator that yields epochs until convergence 
or a maximum number of epochs is reached.

### Experiment
The experiment contains all other objects introduced above. It manages device placement and logdir creation.

# License
MIT License.
