from typing import Generator
import pathlib
import json

import pandas as pd


class AnalyzerResult:
    def __init__(self, results_dir: pathlib.Path,  seed_average: bool = False):
        self.results_dir: pathlib.Path = results_dir

        self.columns = ("exp set name",
                        "exp set dir",
                        "exp set user",
                        "exp dir",
                        "exp seed",
                        "task uid",
                        "task dataset",
                        "task dir",
                        "analysis user",
                        "analysis method",
                        "result name",
                        "result"
                        )

    def get_dataframe(self):

        df = pd.DataFrame(columns=self.columns)
        count = 0

        # with open(str(self.results_dir / "analyzer_kwargs.json"), "r") as fp:
        #     kwargs = json.load(fp)

        seed_dirs = [seed_dir for seed_dir in self.results_dir.iterdir() if seed_dir.is_dir() and "seed" in seed_dir.stem ]
        for seed_dir in seed_dirs:
            for method_dir in [mdir for mdir in seed_dir.iterdir() if mdir.is_dir()]:
                assert (method_dir / "run.log").is_file(), f"Incomplete analysis result found - " \
                                                           f"no logfile in {method_dir}"
                for task_dir in [tdir for tdir in method_dir.iterdir() if tdir.is_dir() and "task" in tdir.stem]:
                    for results_file in [child for child in task_dir.iterdir() if child.suffix == ".json"
                                                                                  and child.is_file()]:
                        with open(str(results_file), "r") as fp:
                            result = json.load(fp)

                            new_row = (result["experiment_set"]["name"],
                                       result["experiment_set"]["dir"],
                                       result["experiment_set"]["user"],
                                       result["experiment"]["dir"],
                                       result["experiment"]["seed"],
                                       [task["uid"] for task in result["task"]],
                                       [task["dataset"] for task in result["task"]],
                                       [task["dir"] for task in result["task"]],
                                       result["user"],
                                       result["method_name"],
                                       result["result_name"],
                                       result["result_values"]
                                       )
                            df.loc[len(df)] = new_row
        return df
