from typing import List, Dict
import pathlib
import time

from path_learning.utils.log import get_timestring
from .utils import ANALYSIS_PLOTDIR
from . import PLOTTING_METHODS


def pick_plot(name):
    try:
        return PLOTTING_METHODS[name]
    except KeyError:
        raise KeyError(f"Unknown plotting method '{name}'. Must be one of {list(PLOTTING_METHODS.keys())}")


class Plotter:
    def __init__(self, df, experiment_name_list: List, **kwargs):
        self.kwargs: Dict = kwargs
        # self.exp_set_name: str = experiment_names
        # self.name: str = kwargs["name"]
        # self.plotting_methods: List[Dict] = kwargs["methods"]
        self.logdir = ANALYSIS_PLOTDIR
        self.df = df
        # experiment_name_list = experiment_names.split(",")
        print(f"Experiment name list: {experiment_name_list}")
        self.folder_name = kwargs[experiment_name_list[0]]["folder_name"]
        self.exp_set_name_list: List[str] = experiment_name_list
        self.name: str = kwargs[experiment_name_list[0]]["name"]
        self.plotting_methods: List[Dict] = kwargs[experiment_name_list[0]]["methods"]

    def plot(self):
        time.sleep(1.0)  # pause 1 second
        timestamp = get_timestring()
        logdir = self.create_logger_logdir(timestamp, self.folder_name)
        for method in self.plotting_methods:
            plot_fct = pick_plot(method["plot-name"])
            plot_fct(self.df, logdir, method)

    @staticmethod
    def create_logger_logdir(timestamp: str, exp_name: str) -> pathlib.Path:
        logdir = ANALYSIS_PLOTDIR / f"{timestamp}_{exp_name}"
        logdir.mkdir(parents=True, exist_ok=False)
        return logdir
