from typing import Dict

from jsonschema import validate

from .kwarg_schemas import *


def test_init_kwargs(func):
    def decorated(self, *args, **kwargs):
        try:
            schema = eval(self.__class__.__name__+"_schema")
        except NameError:
            raise NameError(f"Could not find schema in path_learning.tests.kwarg_schemas "
                            f"for Class <{self.__class__.__name__}>. Before using the validate_kwargs "
                            f"decorator you must define a schema for your class.")
        validate(instance=kwargs, schema=schema)
        func(self, *args, **kwargs)

    return decorated
