"""
Python setup file.
Used to setup paths where to store experimental logs, access to GoogleSheets,
 and installation of package requirements.
"""

import os

import json


def main():
    """
    This script sets up the installation of paths and requirements.
    :return:
    """
    # Requirements:
    print("Installing python dependencies. This step requires python and the 'pip'")
    os.system('pip install --user -r requirements.txt')

    print("----------------------------------------")
    print("Please provide local paths and name of your Google Spreadsheet "
          "to locally setup the experimental environment.")
    print("Provided information will be saved in 'folder_path_settings.json' locally and "
          "can be edited manually")
    print("----------------------------------------")

    # System path settings
    EXP_ROOT_DIR = "/random_path/random_path"
    while not os.path.exists(EXP_ROOT_DIR):
        EXP_ROOT_DIR = input("Provide a valid absolute path for experimental logs:")
        if not os.path.exists(EXP_ROOT_DIR):
            print("The provided path was not valid. Please try again.")

    CREDENTIALS_FILEPATH = "/random_path/random_path"
    while not os.path.exists(CREDENTIALS_FILEPATH):
        CREDENTIALS_FILEPATH = input("Type a valid absolute path for credentials json file, "
                                     "to not use GoogleSheets type 'none':")
        if not os.path.exists(CREDENTIALS_FILEPATH):
            print("The provided credential file path was not valid. Please try again.")

    SPREADSHEET = input("Type the name of the (ideally empty) Google Spreadsheet you want to use "
                        "(not used if previously you typed 'none'):")
    # Data to be written
    dictionary = {
        "ROOT_DIR": EXP_ROOT_DIR,
        "CREDENTIALS_FILEPATH": CREDENTIALS_FILEPATH,
        "SPREADSHEET": SPREADSHEET,
    }

    with open("folder_path_settings.json", "w") as outfile:
        json.dump(dictionary, outfile)
        print("Saving settings json-file locally as 'folder_path_settings.json'")


if __name__ == "__main__":
    main()
