from .task_loss_analysis import TaskBatchLossAnalysis
from .sensitivity_methods import SINGLE_TASK_SENSITIVITY_METHODS
from .exploratory_methods import SINGLE_TASK_EXPLORATORY_METHODS
from .decision_boundary import DecisionBoundaryAnalysis
from .invariance_discrimination_analysis import SingleTaskInvarianceAnalysis


ANALYSIS_METHODS = {
    "task-batch-loss": TaskBatchLossAnalysis,
    "decision-boundary-analysis": DecisionBoundaryAnalysis,
    "invariance-analysis": SingleTaskInvarianceAnalysis,
}

for method_name, constructor in SINGLE_TASK_SENSITIVITY_METHODS.items():
    ANALYSIS_METHODS[method_name] = constructor

for method_name, constructor in SINGLE_TASK_EXPLORATORY_METHODS.items():
    ANALYSIS_METHODS[method_name] = constructor
