import pathlib
import collections
from typing import Dict, Mapping

ANALYSIS_LOGDIR = pathlib.Path(__file__).parent / "logs"
ANALYSIS_PLOTDIR = pathlib.Path(__file__).parent / "plots"


def update_recursively(d: Dict, u: Mapping) -> Dict:
    for k, v in u.items():
        if isinstance(v, collections.abc.Mapping):
            d[k] = update_recursively(d.get(k, {}), v)
        else:
            d[k] = v
    return d