import os
import numpy as np
from PIL import Image
import shutil
import random
random.seed(42)

val_file = 'datasets/DAVIS/ImageSets/2017/val.txt'
l = 44
with open(val_file, 'r') as f:
    video_names = [line.strip() for line in f.readlines()]

source_video_dir = "datasets/DAVIS/JPEGImages/480p"
output_video_dir = 'datasets/DAVIS/JPEGImages-p/480p'
os.makedirs(output_video_dir, exist_ok=True)

for video_idex, video_name in enumerate(video_names):
    print(f"video: {video_name}")

    video_input_dir = os.path.join(source_video_dir, video_name)
    video_output_dir = os.path.join(output_video_dir, video_name)
    shutil.copytree(video_input_dir, video_output_dir)
    
    image_path = os.path.join(video_output_dir, "00001.jpg")
    image = np.array(Image.open(image_path))
    height, width, channels = image.shape
    y = random.randint(0, height - l)
    x = random.randint(0, width - l)
    print(y, x)
    image[y:y+l, x:x+l, :] = 255
    Image.fromarray(image).save(image_path)
    
print("Finsh！")