import os
import numpy as np
from PIL import Image
import random
import shutil

random.seed(42)
l = 44

source_images_dir = "datasets/YTB/2019/valid/JPEGImages"
source_annotations_dir = "datasets/YTB/2019/valid/Annotations"

target_images_dir = "datasets/YTB/2019/valid/JPEGImages-p"

os.makedirs(target_images_dir, exist_ok=True)

for video_folder in os.listdir(source_images_dir):
    video_folder_path = os.path.join(source_images_dir, video_folder)
    if os.path.isdir(video_folder_path):
        target_video_folder = os.path.join(target_images_dir, video_folder)
        if not os.path.exists(target_video_folder):
            shutil.copytree(video_folder_path, target_video_folder)

for video_folder in sorted(os.listdir(source_annotations_dir)):
    video_folder_path = os.path.join(source_annotations_dir, video_folder)
    if not os.path.isdir(video_folder_path):
        continue

    target_video_folder = os.path.join(target_images_dir, video_folder)
    if not os.path.exists(target_video_folder):
        print(f"video {target_video_folder} does not exist, skip it")
        continue

    for annotation_file in sorted(os.listdir(video_folder_path)):
        if not annotation_file.endswith('.png'):
            continue

        frame_number = annotation_file.split('.')[0]
        try:
            frame_num = int(frame_number)
        except ValueError:
            print(f"unable to parse frame number {frame_number}, skip it")
            continue

        next_frame_num = frame_num + 5
        next_frame_number = f"{next_frame_num:05d}"
        next_frame_file = f"{next_frame_number}.jpg"
        next_frame_path = os.path.join(target_video_folder, next_frame_file)

        if not os.path.exists(next_frame_path):
            print(f"frame {next_frame_path} does not exist, skip it")
            continue
        try:
            image = Image.open(next_frame_path)
            image_np = np.array(image)
            height, width = image_np.shape[:2]

            y = random.randint(0, height - l)
            x = random.randint(0, width - l)
            image_np[y:y+l, x:x+l, :] = 255

            modified_image = Image.fromarray(image_np)
            modified_image.save(next_frame_path)

            print(f"add on {next_frame_path}, ({y}, {x})")

        except Exception as e:
            print(f"process the file {next_frame_path} error: {str(e)}")

print("Finish!")
