exp="default"
gpu_num="4"
stage="ytb"
model="aott"
# model="deaott"

## Training of oci##
python tools/train.py --amp \
	--exp_name ${exp} \
	--stage ${stage} \
	--model ${model} \
	--gpu_num ${gpu_num} \
	--poison \
  --oci
#  --trp

## Evaluation on davis2017 val ##
dataset="davis2017"
split="val"
python tools/eval.py --exp_name ${exp} --stage ${stage} --model ${model} \
	--dataset ${dataset} --split ${split} --gpu_num ${gpu_num} --ema

python vos-benchmark/benchmark.py -g "datasets/DAVIS/Annotations/480p/" \
	-m "results/davis2017/davis2017_val_default_AOTT_YTB_ckpt_100000_ema/Annotations/480p/"

## Evaluation on poisoned davis2017 val ##
python tools/eval.py --exp_name ${exp} --stage ${stage} --model ${model} \
	--dataset ${dataset} --split ${split} --gpu_num ${gpu_num} --ema --poison

python vos-benchmark/benchmark.py -g "datasets/DAVIS/Annotations/480p/" \
	-m "results/davis2017/davis2017_val_default_AOTT_YTB_ckpt_100000_ema/Annotations/480p/"

## Evaluation on youtubevos2019 val ##
dataset="youtubevos2019"
split="val"
python tools/eval.py --exp_name ${exp} --stage ${stage} --model ${model} \
	--dataset ${dataset} --split ${split} --gpu_num ${gpu_num} --ema

python vos-benchmark/benchmark.py -g "datasets/YTB/2019/valid/Annotations/" \
	-m "results/youtubevos2019/youtubevos2019_val_default_AOTT_ckpt_100000_ema/Annotations/"

## Evaluation on poisoned youtubevos2019 val ##
python tools/eval.py --exp_name ${exp} --stage ${stage} --model ${model} \
	--dataset ${dataset} --split ${split} --gpu_num ${gpu_num} --ema --poison

python vos-benchmark/benchmark.py -g "datasets/YTB/2019/valid/Annotations/" \
	-m "results/youtubevos2019/youtubevos2019_val_default_AOTT_ckpt_100000_ema/Annotations/"