
import yaml
from transformers import (
    AutoModelForCausalLM,
    AutoTokenizer,)
from peft import (
    PeftModel,
)
from typing import Dict, Any
def load_config(config_path: str) -> Dict[str, Any]:
    with open(config_path, 'r', encoding='utf-8') as f:
        return yaml.safe_load(f)

def main():

    name = "deepseek-ai/DeepSeek-R1-Distill-Qwen-7B"

    base_model = AutoModelForCausalLM.from_pretrained(
        name,
        device_map='auto',
        torch_dtype='auto',
    )

    tokenizer = AutoTokenizer.from_pretrained(name)

    peft_model = PeftModel.from_pretrained(base_model, "model/R1_VeriThinker_Qwen_7B_lora")

    merged_model = peft_model.merge_and_unload()

    merged_model.save_pretrained("model/R1_VeriThinker_Qwen_7B")
    tokenizer.save_pretrained("model/R1_VeriThinker_Qwen_7B")


if __name__ == "__main__":
    main()