"""
Pre-initialization for FloorPlan4 task.
FloorPlan4's drawers are closed so the agent can later open
"""

class SceneInitializer:
    def __init__(self) -> None:
        self.drawers = ['Drawer|-02.50|+00.61|+00.59', 
                        'Drawer|-02.50|+00.22|+00.59', 
                        'Drawer|-02.04|+00.61|+00.59', 
                        'Drawer|-02.04|+00.22|+00.59', 
                        'Drawer|-02.04|+00.94|+00.60', 
                        'Drawer|-02.51|+00.94|+00.60']

    def preinit(self, event, controller):
        """Pre-initialize the environment for the task.
    
        Args:
            event: env.event object
            controller: ai2thor.controller object
    
        Returns:
            event: env.event object
        """

            # initialization function - autogenerated

        for drawer in self.drawers: 
            event = controller.step(
            action = 'CloseObject',
            objectId = drawer,
            forceAction = True
            )

        return event