"""
Pre-initialization for FloorPlan2 task.
FloorPlan2: 
- put the plate, mug, and bowl in their respective positions
"""

class SceneInitializer:
    def __init__(self) -> None:
        pass

    def preinit(self, event, controller):
        """Pre-initialize the environment for the task.
    
        Args:
            event: env.event object
            controller: ai2thor.controller object
    
        Returns:
            event: env.event object
        """

            # initialization function - autogenerated

        event=controller.step(
            action='PlaceObjectAtPoint',
            objectId='Plate|+01.32|+01.67|-01.60',
            position={'x': -0.1085974454879761, 'y': 0.9157510995864868, 'z': 0.698094911575317}
        )

        event=controller.step(
            action='PlaceObjectAtPoint',
            objectId='Bowl|+00.28|+00.92|+01.09',
            position={'x': -0.3085974454879761, 'y': 0.9157510995864868, 'z': 0.398094911575317}
        )

        event=controller.step(
            action='PlaceObjectAtPoint',
            objectId='Mug|-00.24|+00.92|-00.26',
            position={'x': -0.23500609397888184, 'y': 0.9150363206863403, 'z': -0.2559991180896759}
        )

        return event