"""
Map tasks to the file to import the right preinit function for the task.
"""

import os
import importlib.util


def import_module_from_file(file_path: str, module_name: str):
    """Import module from file path.
    Example:
    func = import_module_from_file('Tasks/4_clean_floor_kitchen/FloorPlan1.py','preinit')
    func(event, controller)
    """
    spec = importlib.util.spec_from_file_location(module_name, file_path)
    module = importlib.util.module_from_spec(spec)
    spec.loader.exec_module(module)
    return module


def get_scene_initializer(task: str, floor_plan: str):
    """Map the task to the file to import the right preinit function for the task.

    Args:
        task: str, task name

    Returns:
        str: file name to import the preinit function for the task
    """
    file_path = os.path.dirname(os.path.realpath(__file__))
    file_path += "/" + task + "/" + floor_plan + ".py"
    assert os.path.exists(
        file_path
    ), f"File {file_path}. Likely cause: {floor_plan} is not applicable to {task}"

    checker_file_path = (
        os.path.dirname(os.path.abspath(__file__)) + "/" + task + "/checker.py"
    )

    # # type 1 tasks
    # if task == "Put a bread, lettuce and tomato in the fridge":
    #     file_path += "1_put_bread_lettuce_tomato/"
    #     checker_file_path += "1_put_bread_lettuce_tomato/checker.py"
    # elif task == "Put the pots and pans on the stove burners":
    #     file_path += "1_put_pots_pans_stove_burner/"
    #     checker_file_path += "1_put_pots_pans_stove_burner/checker.py"
    # elif task == "Slice the bread and tomato and crack the egg":
    #     file_path += "1_slice_bread_tomato_crack_egg/"
    #     checker_file_path += "1_slice_bread_tomato_crack_egg/checker.py"
    # elif task == "Put the butter knife, bowl, and mug in the sink":
    #     file_path += "1_put_knife_bowl_mug_sink/"
    #     checker_file_path += "1_put_knife_bowl_mug_sink/checker.py"
    # elif task == "Turn off the faucet and light if either is on":
    #     file_path += "1_turn_off_faucet_light/"
    #     checker_file_path += "1_turn_off_faucet_light/checker.py"
    # elif task == "Put the tissue box, keys, and plate in the box":
    #     file_path += "1_put_tissue_keys_plate_box/"
    #     checker_file_path += "1_put_tissue_keys_plate_box/checker.py"
    # elif task == "Put the computer, book, and pen on the couch":
    #     file_path += "1_put_computer_book_pen_couch/"
    #     checker_file_path += "1_put_computer_book_pen_couch/checker.py"
    # elif task == "Put the bowl and tissue box on the table":
    #     file_path += "1_put_vase_tissuebox_remotecontrol_table/"
    #     checker_file_path += "1_put_vase_tissuebox_remotecontrol_table/checker.py"
    # # type 2 tasks
    # elif task == "Open all the drawers":
    #     file_path += "2_open_all_drawers/"
    #     checker_file_path += "2_open_all_drawers/checker.py"
    # elif task == "Open all the cabinets":
    #     file_path += "2_open_all_cabinets/"
    #     checker_file_path += "2_open_all_cabinets/checker.py"
    # elif task == "Turn on all the stove knobs":
    #     file_path += "2_turn_on_all_stove_knobs/"
    #     checker_file_path += "2_turn_on_all_stove_knobs/checker.py"
    # elif task == "Put all the vases on the countertop":
    #     file_path += "2_put_all_vases_countertop/"
    #     checker_file_path += "2_put_all_vases_countertop/checker.py"
    # elif task == "Put all the tomatoes and potatoes in the fridge":
    #     file_path += "2_put_all_tomatoes_potatoes_fridge/"
    #     checker_file_path += "2_put_all_tomatoes_potatoes_fridge/checker.py"
    # elif task == "Put all pencils and pens in the box":
    #     file_path += "2_put_all_pencils_pens_box/"
    #     checker_file_path += "2_put_all_pencils_pens_box/checker.py"
    # elif task == "Move all lamps next to the door":
    #     file_path += "2_move_all_lamps_door/"
    #     checker_file_path += "2_move_all_lamps_door/checker.py"
    # elif task == "Wash the bowl, mug, pot, and pan":
    #     file_path += "1_wash_bowl_mug_pot_pan/"
    #     checker_file_path += "1_wash_bowl_mug_pot_pan/checker.py"
    # # type 3 tasks
    # elif task == "Put all groceries in the fridge":
    #     file_path += "3_put_all_groceries_fridge/"
    #     checker_file_path += "3_put_all_groceries_fridge/checker.py"
    # elif task == "Put all shakers in the closest drawer":
    #     file_path += "3_put_all_shakers_drawer/"
    #     checker_file_path += "3_put_all_shakers_drawer/checker.py"
    # elif task == "Put all silverware in the sink":
    #     file_path += "3_put_all_silverware_sink/"
    #     checker_file_path += "3_put_all_silverware_sink/checker.py"
    # elif task == "Put all school supplies on the couch":
    #     file_path += "3_put_all_school_supplies_couch/"
    #     checker_file_path += "3_put_all_school_supplies_couch/checker.py"
    # elif task == "Move everything on the table to the desk":
    #     file_path += "3_clear_table_to_desk/"
    #     checker_file_path += "3_clear_table_to_desk/checker.py"
    # elif task == "Put all kitchenware in the cardboard box":
    #     file_path += "3_put_all_kitchenware_box/"
    #     checker_file_path += "3_put_all_kitchenware_box/checker.py"
    # # type 4 tasks
    # elif (
    #     task
    #     == "Clear the kitchen floor by placing items at their appropriate positions"
    # ):
    #     file_path += "4_clear_floor_kitchen/"
    #     checker_file_path += "4_clear_floor_kitchen/checker.py"
    # elif (
    #     task
    #     == "Clear the kitchen table by placing the items in their appropriate positions"
    # ):
    #     file_path += "4_clear_table_kitchen/"
    #     checker_file_path += "4_clear_table_kitchen/checker.py"
    # elif (
    #     task
    #     == "Clear the kitchen countertop by placing items in their appropriate positions"
    # ):
    #     file_path += "4_clear_countertop_kitchen/"
    #     checker_file_path += "4_clear_countertop_kitchen/checker.py"
    # elif (
    #     task
    #     == "Clear the livingroom desk by placing the items in other appropriate positions"
    # ):
    #     file_path += "4_clear_desk_livingroom/"
    #     checker_file_path += "4_clear_desk_livingroom/checker.py"
    # elif (
    #     task
    #     == "Clear the livingroom table by placing the items in other appropriate positions"
    # ):
    #     file_path += "4_clear_table_livingroom/"
    #     checker_file_path += "4_clear_table_livingroom/checker.py"
    # elif task == "Clear the couch by placing the items in other appropriate positions":
    #     file_path += "4_clear_couch_livingroom/"
    #     checker_file_path += "4_clear_couch_livingroom/checker.py"
    # else:
    #     print("Task not found")
    #     return None, None

    # file_path += floor_plan + ".py"
    scene_initializer = import_module_from_file(file_path, "SceneInitializer")
    checker = import_module_from_file(checker_file_path, "Checker")

    # print(dir(scene_initializer))
    # preinit_func = import_module_from_file(file_path, "SceneInitializer").preinit

    return scene_initializer, checker


# if __name__ == "__main__":
#     import os

#     print(__file__)
#     print(os.path.dirname(os.path.realpath(__file__)))
