"""
Pre-initialization for FloorPlan1 task.
FloorPlan1: the tomato and bread do not need to be moved
The egg needs to be moved out of the fridge
"""

class SceneInitializer:
    def __init__(self) -> None:
        pass

    def preinit(self, event, controller):
        """Pre-initialize the environment for the task.
    
        Args:
            event: env.event object
            controller: ai2thor.controller object
    
        Returns:
            event: env.event object
        """

            # initialization function - autogenerated

        event=controller.step(
            action='PlaceObjectAtPoint',
            objectId='Bread|-00.52|+01.17|-00.03',
            position={'x': -0.5223836302757263, 'y': 1.1704490184783936, 'z': -0.028279820457100868}
        )

        event=controller.step(
            action='PlaceObjectAtPoint',
            objectId='Tomato|-00.39|+01.14|-00.81',
            position= {'x': -0.3850494921207428, 'y': 1.1370344161987305, 'z': -0.8119606971740723}
        )

        event=controller.step(
            action='PlaceObjectAtPoint',
            objectId= 'Egg|-02.04|+00.81|+01.24',
            position= {'x': -0.5013247728347778, 'y': 1.2045999765396118, 'z': -1.0120956897735596}
        )

        event=controller.step(
            action='PlaceObjectAtPoint',
            objectId= 'Lettuce|-01.81|+00.97|-00.94',
            position= {'x': -1.8069772720336914, 'y': 0.9737606048583984, 'z': -0.9429917931556702}
        )

        return event