"""
Pre-initialization for FloorPlan2 task.
FloorPlan2's drawers are closed so the agent can later open
"""

class SceneInitializer:
    def __init__(self) -> None:
        self.drawers = ['Drawer|+00.81|+00.48|-01.16', 
                        'Drawer|+01.50|+00.20|-00.02', 
                        'Drawer|+01.50|+00.63|-00.02', 
                        'Drawer|+01.50|+00.14|+00.60', 
                        'Drawer|+01.50|+00.60|-00.02', 
                        'Drawer|+01.50|+00.20|+01.22', 
                        'Drawer|+01.50|+00.78|+01.22', 
                        'Drawer|+01.50|+00.31|+00.60', 
                        'Drawer|+01.50|+00.54|+00.60', 
                        'Drawer|+01.50|+00.63|+00.61', 
                        'Drawer|+01.50|+00.43|-00.02', 
                        'Drawer|-00.70|+00.48|-01.16', 
                        'Drawer|+01.50|+00.52|+01.22']

    def preinit(self, event, controller):
        """Pre-initialize the environment for the task.
    
        Args:
            event: env.event object
            controller: ai2thor.controller object
    
        Returns:
            event: env.event object
        """

            # initialization function - autogenerated

        for drawer in self.drawers: 
            event = controller.step(
            action = 'CloseObject',
            objectId = drawer,
            forceAction = True
            )

        return event