"""
Pre-initialization for FloorPlan3 task.
FloorPlan3's drawers are closed so the agent can later open
"""

class SceneInitializer:
    def __init__(self) -> None:
        self.drawers = ['Drawer|+00.65|+00.85|+00.68', 
                        'Drawer|+00.65|+01.07|+01.02', 
                        'Drawer|+00.65|+01.07|+00.68', 
                        'Drawer|+00.65|+00.60|+01.02', 
                        'Drawer|-01.61|+00.68|-01.22', 
                        'Drawer|-01.61|+00.68|-00.43', 
                        'Drawer|+00.65|+00.60|+00.68', 
                        'Drawer|+00.65|+00.85|+01.02']

    def preinit(self, event, controller):
        """Pre-initialize the environment for the task.
    
        Args:
            event: env.event object
            controller: ai2thor.controller object
    
        Returns:
            event: env.event object
        """

            # initialization function - autogenerated

        for drawer in self.drawers: 
            event = controller.step(
            action = 'CloseObject',
            objectId = drawer,
            forceAction = True
            )

        return event