"""
Pre-initialization for FloorPlan1 task.
FloorPlan1: 
- move the pot out of the way and move the bowl to the location of the pot
- place the plate and mug on the island
"""

class SceneInitializer:
    def __init__(self) -> None:
        pass

    def preinit(self, event, controller):
        """Pre-initialize the environment for the task.
    
        Args:
            event: env.event object
            controller: ai2thor.controller object
    
        Returns:
            event: env.event object
        """

            # initialization function - autogenerated
        
        event=controller.step(
            action='PlaceObjectAtPoint',
            objectId='Pot|-01.22|+00.90|-02.36',
            position= {'x': 0, 'y': 0, 'z': 0}
        )

        event=controller.step(
            action='PlaceObjectAtPoint',
            objectId='Bowl|+00.27|+01.10|-00.75',
            position= {'x': -1.2490016508102417, 'y': 0.9009172916412354, 'z': -2.3559999465942383}
        )

        event=controller.step(
            action='PlaceObjectAtPoint',
            objectId='Plate|+00.96|+01.65|-02.61',
            position= {'x': 0.2731873095035553, 'y': 1.1010472774505615, 'z': -0.7532863020896912}
        )

        event=controller.step(
            action='PlaceObjectAtPoint',
            objectId='Mug|-01.76|+00.90|-00.62',
            position={'x': -0.08504892587661743, 'y': 1.137034296989441, 'z': -0.8119610548019409}
        )

        return event