import os
import importlib
import glob
import re

"""
Convert the output from init_fns.py into the correct task class 
"""

begin='\"""\nPre-initialization for {scene} task.\n'
end='\n\"""\n'
wrap=lambda s, scn: begin.format(scene=scn)+s+end

# define 'docstring' functions -----
default=lambda scene, task_dsc: wrap(f'{scene} does not need any modifications for the task\nof {task_dsc}', scene)

# @change - make your own 'descriptor' function (see 'sink' function above to see format, create one)
#   -description functions to apply to each task (description varies per task, so we have the function do the work)
# or just use 'default'
def sink(scene, task_dsc):
    """
    Example fn for description. The description at the top of output file changes depending on floorplan & task.
    task_dsc.
        -Each string _blt_s has '{scene}' inside so that the wrap at the end can .format() the correct scene
        -The strings just describe changes (if nothing was changed, use default)
        -Change name of string at the end return function
    """

    # @change - put here floorplans where something changed
    if scene in ['FloorPlan2', 'FloorPlan3', 'FloorPlan5']:
        # describe the change here, using the scene (floorplan n)
        _blt_s='{scene}\'s lettuce was moved to visible position'

    # @change - put here floorplans where nothing changed
    else:
        # if not one of these floorplans, return the default response (nothing changed)
        return default(scene, task_dsc)

    # @change - only change the name '_blt_s' to whatever name the string you created is called
    return wrap(_blt_s.format(scene=scene), scene)

# this one just does nothing, plug into descriptions if you wish to
null=lambda s,t: ''

descriptions=[sink]


#@change - add directory -> [description, function] map
#   -add dictionary mapping:
#       directory_name (key) to -> list of [task_description, task_descriptor_function] (value)
#                                           task_descriptor_function is the 'sink' one we created above
# IMPORTANT: the directory should be the same name as you put in 'init_fns.py'
task_dict={'1_put_knife_bowl_mug_sink' : ['putting utensils in the sink', sink]}


if not os.path.exists('./init_maker/inits'):
    os.mkdir('./init_maker/inits')

for dr,arr in (task_dict.items()):
    tsk_dsc,description_fn=arr
    # you can change folder that it goes to too
    to_dir=f'./init_maker/inits/{dr}/'
    # make the {dr} part inside the 'inits' folder
    if not os.path.exists(to_dir):
        os.makedirs(to_dir)
    appd=f'./init_maker/fns/{dr}/'
    init_fns=glob.glob(appd+'*')
    # filter out __pycache__
    init_fns=list(filter(lambda x: 'pycache' not in x, init_fns))
    for fn in init_fns:
        h,fn=os.path.split(fn) # get actual fn (without directory head)
        fs=open(appd+fn, 'r').read()
        func_header="""
    def preinit(self, event, controller):"""
        func_body=fs.split('\n')[1:]
        func=func_header+'\n    '.join(func_body)
        # get fn number
        extract_number=lambda s: re.findall(r'\d+',s)[0]
        scene='FloorPlan'+str(extract_number(fn))
        docs=description_fn(scene,tsk_dsc)
        cls="""
class SceneInitializer:
    def __init__(self) -> None:
        pass
        """
        content=docs+cls+func
        # write to files
        with open(to_dir+scene+'.py', 'w+') as f:
            f.write(content)

        # safe mode - print
        # print(content, '\n')
        
