# Federated Learning from Vision-Language Foundation Models: Theoretical Analysis and Method

# Title

We provide the code for our paper "Federated Learning from Vision-Language Foundation Models: Theoretical Analysis and Method." This repository implements PromptFolio, a global-local prompt fusion algorithm for prompt-based federated learning using vision-language foundation models. This code heavily relies on the FedOTP code repository.

## Installation

To install the required packages, run:
- `pip3 install -r requirements.txt`

You should update the dataset path in `federated_main.py`:
```python
parser.add_argument("--root", type=str, default="/data/dataset", help="path to your dataset") 
```

## How to Run

Use the following commands to reproduce our results:

#### PromptFolio with 0.2 mixing coefficient
```commandline
python -u federated_main.py --dataset-config-file configs/datasets/cifar100.yaml --frac_p 1 --num_users 10 
```

#### CoOp
```commandline
python -u federated_main.py --dataset-config-file configs/datasets/cifar100.yaml --frac_p 0 --num_users 10 
```

#### PromptFL
```commandline
python -u federated_main.py --dataset-config-file configs/datasets/cifar100.yaml --frac_p 0.2 --num_users 10 
```

## Modify Configuration

### Dataset
Change the `--dataset-config-file` argument to the desired dataset.

### Data Heterogeneity
Decrease `--beta` to increase distribution heterogeneity.

### User Number
Change `--num_users` to adjust the total number of users involved in training.

### Mixing Coefficient Ratio
Modify `--frac_p` to change the mixing coefficient ratio.

After completing the experiments, all results will be saved to the `output/` directory. 


